#  file loading dummy  #
proc perlMenu.tcl {} {}

#############################################################################
#  Build the perl menu  #
#            

menu::buildProc perlMenu menu::buildPerl
menu::buildProc generalOptions menu::buildgeneralOptions
menu::buildProc filterOptions menu::buildfilterOptions
menu::buildProc perlFilterMenu rebuildFilterMenu

set perlFilterMenu "textFilters"

proc menu::buildPerl {} {
	global PerlmodeVars perlFilterMenu perlMenu 
	set ma {
		"/'<Umacperl"
		{Menu -m -n "tellMacperl..." -p perlTellProc {
		   "/O<UOpen This File"
		   "Save As Droplet"
		   "Save As Runtime"
		   "Save As CGI"
			"(-"
		   "Get Output Window"
		   "Close Output Window"
		   "Quit"
	       }
		} 
		{Menu -m -n "Quick Save As..." -p perlSaveProc {
		   "Droplet"
		   "Runtime"
		   "CGI"
	       }
		} 
		{Menu -m -n help -p perlHelpProc {
			"MacPerl Mode"
			"Mac Specifics"
			"Perl4 Manual"
			"Perl5 Manual"
		}}
		"(-"
		"runTheSelection"
		"/R<UrunTheBuffer"
		"/R<B<OsaveAndRun"
		"runAFile"
		"(-"
	}
	lappend ma [list Menu -n $perlFilterMenu {}] \
	  "selectBufferAsFilter" "selectFileAsFilter"
	lappend ma "/F<UrepeatLastFilter"
#	We enable this menu item without checking for a valid last filter; we'll 
#	disable it after 'menu::buildSome perlMenu' is called. (RBC 02-MAR-1999)	
	lappend ma "(-" \
	  [list Menu -n generalOptions {}] \
	  [list Menu -n filterOptions {}]

	return [list build $ma -1 \
	  {generalOptions filterOptions perlFilterMenu} $perlMenu]
}

# General Perl-menu options menu
#
proc menu::buildgeneralOptions {} {
	global PerlmodeVars
	foreach i {"retrieveOutput" "autoSwitch" "promptForArgs" "useDebugger"} {
		if [set PerlmodeVars(perl$i)] {
			lappend ma "!$i"
		} else {
			lappend ma $i
		}
	}
	return [list build $ma]
}

# Text Filter options menu
#
proc menu::buildfilterOptions {} {
	global PerlmodeVars
	Menu -n filterOptions {
		"applyToBuffer"
		"overwriteSelection"
		"(-"
		"rebuildFilterMenu"
	}	
	markMenuItem filterOptions overwriteSelection $PerlmodeVars(perloverwriteSelection)
	markMenuItem filterOptions applyToBuffer $PerlmodeVars(perlapplyToBuffer)
}

#############################################################################
#  filter menu builder  #
#  Build a submenu of "preattached" Perl filters using the names of the 
#  scripts in the Text Filters directory.  Called whenever Text Filters
# folder is reassigned.
#
proc rebuildFilterMenu {{args}} {
	global PerlmodeVars perlFilters perlFilterMenu perlFilterPath
	global PerlmodeVars $perlFilterMenu
	
	eval [menu::buildHierarchy [list $PerlmodeVars(perlFilterPath)] $perlFilterMenu textFiltersProc perlFilters]
}

menu::buildSome perlMenu
if {$PerlmodeVars(perlPrevScript) == {} || $PerlmodeVars(perlPrevScript) == {*startup*}} {
		enableMenuItem $perlMenu repeatLastFilter 0 
	} 
# After building menu, disable "repeatLastFilter" command since there isn't a filter
# yet. The if statement should always be true on the initial build. (RBC 02-MAR-1999) 


#  var & menu updater  #
# ShadowPerl sets the global PerlmodeVars vars when the mode vars are modified and
# keeps the menu checkmarked correctly.
#
proc shadowPerl {name} {
	global PerlmodeVars HOME perlMenu
	switch $name {
		"perluseDebugger"	{
			markMenuItem generalOptions useDebugger $PerlmodeVars(perluseDebugger)
		 }
		"perloverwriteSelection"	{
			markMenuItem filterOptions overwriteSelection $PerlmodeVars(perloverwriteSelection)
		 }
		"perlapplyToBuffer"	{
			markMenuItem filterOptions applyToBuffer $PerlmodeVars(perlapplyToBuffer)
		 }
		"perlretrieveOutput"	{
			markMenuItem generalOptions retrieveOutput $PerlmodeVars(perlretrieveOutput) 
		}
		"perlautoSwitch" {	
			markMenuItem generalOptions autoSwitch $PerlmodeVars(perlautoSwitch) 
		}
		"perlpromptForArgs" {	
			markMenuItem generalOptions promptForArgs $PerlmodeVars(perlpromptForArgs) 
		}
		"perlVersion" {	
			set modeCode "perl${perlVersion}.tcl"
			if {[catch "$modeCode"]} {
				alertnote "Couldn't load the Perl-mode colorization file \"$modeCode\".  Contact the maintainer."
			}
		}
		"perlLastFilter" {	
			# Don't allow perlPrevScript to be changed from the flags menu
			if {$PerlmodeVars(perlPrevScript) == "*startup*"} {
				set PerlmodeVars(perlPrevScript) $perlLastFilter
				enableMenuItem $perlMenu repeatLastFilter 1
			} else {
				set perlLastFilter $PerlmodeVars(perlPrevScript) 
			}
		}
	}
}

#############################################################################
#  Menu commands  #
#############################################################################

###########################################################################
#
proc perlHelpProc {menu item} {
	global PerlmodeVars HOME
	switch $item {
		"MacPerl Mode"	{
				if {[catch {openFileQuietly "$HOME:Help:MacPerl Help"}]} {
					alertnote "File not found:\r$HOME:Help:MacPerl Help"
				}
			}
		"Mac Specifics"	{
				if {[catch {openFileQuietly "$HOME:Help:MacPerl.Specifics"}]} {
					alertnote "File not found:\r$HOME:Help:MacPerl.Specifics"
				}
			}
		"Perl4 Manual"	{
				if {[catch {openFileQuietly "$HOME:Help:Perl Commands"}]} {
					alertnote "File not found:\r$HOME:Help:Perl Commands"
				}
			}
		"Perl5 Manual"	{
				catch {editMark "$HOME:Help:Perl Commands" Perl5 -r}
			}
	}
}

############################################################################
#  toggle flags  #
# Toggle the perl menu flags
#
proc retrieveOutput {} {
    perlFlip perlretrieveOutput
}

proc useDebugger {} {
    perlFlip perluseDebugger
}

proc autoSwitch {} {
	perlFlip perlautoSwitch
}

proc perlFlip {var} {
	global PerlmodeVars
	set PerlmodeVars($var) [expr [set PerlmodeVars($var)] ? 0 : 1]
	synchroniseModeVar $var $PerlmodeVars($var)
	shadowPerl $var
}

proc overwriteSelection {} {
    perlFlip perloverwriteSelection
}

proc applyToBuffer {} {
    perlFlip perlapplyToBuffer
}

proc promptForArgs {} {
    perlFlip perlpromptForArgs
}

#############################################################################
#  Switch to MacPerl  #
# 
proc macperl {} {
	app::launchFore McPL
}

#############################################################################
#  other MacPerl interactions  #
# Interact with MacPerl in some other way besides executing a script
#
#DTH: note addition of two lines for auto-save
proc perlTellProc {menu name} {
	switch -exact $name {
	"Open This File"		{ openInMacperl }
	
	"Save As Droplet"		{ saveThruMacperl "droplet" }
	
	"Save As Runtime"		{ saveThruMacperl "runtime" }
	
	"Save As CGI"			{ saveThruMacperl "cgi" }
	
	"Get Output Window"		{ openPerlOutput }
	
	"Close Output Window"	{ sendCloseWinName MacPerl $perlName ;
							  sendCloseWinName MacPerl "Perl Debug" }
							
	"Quit"					{ quitMacperl }
	}
}

proc perlSaveProc {menu name} {
	switch -exact $name {
	"Droplet"	{ saveThruMacperl "auto-droplet" }
	
	"Runtime"	{ saveThruMacperl "auto-runtime" }

	"CGI"		{ saveThruMacperl "auto-cgi" }
	}
}

#############################################################################
#  open curr file in MacPerl  #
# Open the current file under MacPerl.  This used to useful for saving files 
# as droplets or runtime scripts.  Maybe it's still useful for something...?
#
proc openInMacperl {} {
	if {[winDirty]} {
		case [askyesno -c "Save '[lindex [winNames] 0]'?"] in {
			"yes" {save}
			"no" {}
			"cancel" {return}
		}
	}
	set name [app::launchFore McPL]
	sendOpenEvent -n [file tail $name] [win::Current]
}

#############################################################################
#  save as droplet or runtime  #
# Save the script in the current window as a MacPerl droplet or 
# runtime script.  
#
proc saveThruMacperl {type} {
	global PerlmodeVars ALPHA

	set name [file tail [app::launchBack McPL]]
	getWinInfo arr
	if {$arr(dirty) == 1} {
		case [askyesno -c "Save '[lindex [winNames] 0]' source file also?"] in {
			"yes" {save}
			"no" {}
			"cancel" {return}
		}
	}
	#DTH note the following "if" block which replaced what is in the new "else" block
	set myName [lindex [winNames -f] 0]
	if {$type == "auto-droplet" || $type == "auto-runtime"} {
		if {[file extension $myName] == ".pl"} {
			set destfile [AEFilename [file rootname $myName]]
		} else {
			set destfile [AEFilename [file rootname $myName]]
		}
	} elseif {$type == "auto-cgi"} {
		set destfile [AEFilename "[file rootname $myName].cgi"]
	} else {
		set destfile [AEFilename [putfile {Save droplet as} [lindex [winNames] 0]]]
	}

	set script [curlyq [getText [minPos] [maxPos]]]
	#DTH note addition of "auto-xxx" in two lines below
	if {$type == "droplet" || $type == "auto-droplet"} {
		set saveType "SCPT"
	} elseif {$type == "runtime" || $type == "auto-runtime"} {
		set saveType "MrP7"
	} elseif {$type == "cgi" || $type == "auto-cgi"} {
		set saveType "'WWW'"
	} elseif {$type == "text"} {
		set saveType "TEXT"
	}
	
	set err [catch {eval "AEBuild -t 36000 -r \"$name\"" core save {----} [list $script] {dest:} [list $destfile] {fltp:} $saveType } reply ]
	if {$err} { message "AEBuild error code $err in saveThruMacperl" }
	
# The following lines could be used to tell MacPerl to take the script file 
# from an existing disk file and then re-save it in the desired form.
#
#	set srcfile "\[ [AEFilename [win::Current]] \]"
#	set reply [eval "AEBuild -t 36000 -r \"$name\"" core save {----} [list $srcfile] {dest:} [list $destfile] {fltp:} $saveType ]
#
}

#############################################################################
#  Quit a running MacPerl app  #
# 
proc quitMacperl {} {
	foreach proc [processes] {
		set sig [lindex $proc 1]
		if {$sig == "McPL"} {
			sendQuitEvent [lindex $proc 0]
			# switchTo is necessary to keep MacPerl from blinking
			switchTo [lindex $proc 0]	
		}
	}
}

#############################################################################
#  run something via MacPerl  #
# (No special arrangements are made to provide input or capture the output)
# 
proc runTheSelection {} {
	global PerlmodeVars scriptFile scriptStart
	set scriptFile [win::Current]
	set scriptStart [lindex [posToRowCol [getPos]] 0]
	perlExecuteScript [getSelect]
}
 
proc runTheBuffer {} {
	global PerlmodeVars scriptFile scriptStart
	set scriptFile [win::Current]
	set scriptStart 1
	perlExecuteScript [getText [minPos] [maxPos]]
}

proc runAFile {} {
	global PerlmodeVars scriptFile scriptStart
	if {! [catch {getfile "Select a Perl script"} path]} {
		set scriptFile $path
		set scriptStart 1
		perlExecuteFile $path
	}
}

proc saveAndRun {} {
	global PerlmodeVars scriptFile scriptStart
	save
	set path [win::Current]   
	set scriptFile $path
	set scriptStart 1
	perlExecuteFile $path
}


